/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.message.VWConsoleMsg;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWTaskCellRenderer
extends DefaultTableCellRenderer {
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        VWTaskUtil.updateComponentOrientation(component);
        component.setText("");
        component.setIcon(null);
        if (ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight()) {
            component.setHorizontalAlignment(2);
        } else {
            component.setHorizontalAlignment(4);
        }
        if (value == null) {
            return component;
        }
        if (value instanceof VWTaskBaseNode) {
            component.setText(((VWTaskBaseNode)value).getName());
            component.setIcon(((VWTaskBaseNode)value).getIcon16());
        } else if (value instanceof VWConsoleMsg) {
            component.setText(((VWConsoleMsg)value).getSourceName());
            component.setIcon(((VWConsoleMsg)value).getSourceIcon());
        } else if (value instanceof Icon) {
            component.setIcon((Icon)value);
            component.setHorizontalAlignment(0);
        } else if (value instanceof Integer) {
            component.setText(value.toString());
        } else if (value instanceof Date) {
            component.setText(DateFormat.getDateTimeInstance().format((Date)value));
        } else if (value instanceof String) {
            component.setText(value.toString());
        }
        return component;
    }
}

